import React from 'react';
import LinearProgress from '@material-ui/core/LinearProgress';
import useStyles from './styles';

type Props = {
    downloadProgress: number,
    strings: object
};

function DownloadingUpdate({ downloadProgress, strings }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.downloadingUpdateContainer}>
            <LinearProgress
                classes={{
                    root: classes.linearDownloadingRoot,
                    bar: classes.linearDownloadingBar
                }}
                variant="determinate"
                value={downloadProgress}
            />
            <div className={classes.downloadingUpdateTitle}>
                {strings.welcome_downloading_app_update}
            </div>
        </div>
    );
}

export default DownloadingUpdate;
